<?php

$page_title = _("Search Results");

include("includes/header.php");
use SubjectsPlus\Control\Search;

if (isset($_POST["searchterm"])) {
	$search = new Search;
	$search->setSearch($_POST['searchterm']);

	$results = $search->getResults();

	// Loop through each content type returned in array
	foreach ($results as $result) {
		
		switch($result['content_type']) {

	 	  case 'Record':
	 	  	$records_results[] = "<a href='records/record.php?record_id=" . $result['id'] . "'/>" . $result['matching_text'] .  "</a>";	    
		    break;

	 	  case 'Talkback':
	 	  	$talkback_results[] = "<a href='talkback/talkback.php?talkback_id=" . $result['id'] . "'/>" . $result['matching_text'] .  "</a>";	    
		    break;

		  case 'Subject Guide':
		    $guides_results[] = "<a href='guides/guide.php?subject_id=" . $result['id'] . "'/>". $result['matching_text'] ."</a>";
		    break;

		  case 'FAQ':
		    $faq_results[] = "<a href='faq/faq.php?faq_id=" . $result['id'] . "'/>". $result['matching_text'] ."</a>";
		    break;

		  case 'Pluslet':
		    $pluslets_results[] = "<a href='guides/guide.php?subject_id=" . $result['parent_id'] . "#box-" . $result['tab_index'] . "-" . $result['id'] . "'/>" . $result['matching_text'] . "</a>";	    
		    break;
		  case 'Staff':
		    $staff_results[] = "<a href='staff/staff.php?staff_id=" . $result['id'] . "'/>". $result['matching_text'] ."</a>";	    
		    break;
		}   
	}

	// Now build our display

	$search_types = array("records", "guides", "plulsets", "faq", "staff", "talkback");

	    $colour1 = "#fff";
	    $colour2 = "#F6E3E7";
	    $colour3 = "highlight";

	$search_result = '';

	    foreach ($search_types as $key) {
	        $row_count = 0;
	        $currentArray = $key . "_results";
	        global $$currentArray;

	        if ($$currentArray) {
	            $intro = ""; // clear out the intro
	            $search_result .= "<h3>" . ucfirst($key) . "</h3>";

	            foreach ($$currentArray as $value) {
	                $row_colour = ($row_count % 2) ? $colour1 : $colour2;
	                $search_result .= "<div style=\"background-color:$row_colour ; padding: 2px;\" class=\"striper\">
	&nbsp;&nbsp;<img src=\"$IconPath/required.png\" alt=\"bullet\" /> " . $value . "</div>";
	                $row_count++;
	            }
	        }
	    }

$subtitle = _("Search Results for ") . $_POST['searchterm'];

} else {
	$subtitle = _("No search term entered");
	$search_result =  _("<p>Please search for something with the box above.</p>");
}
?>
<div id="main-content">
  <div class="pure-g-r">
    <div class="pure-u-1-2">

	<?php
	
	makePluslet($subtitle, $search_result, "no_overflow");
	?> 

    </div>
  </div>
</div>

<?php 

//print "<pre>";
//print_r($results);

include("includes/footer.php");

?>